/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.InterpreterListener;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.StateMachine;
import DE.siemens.ad.logo.util.VariableMemory;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.util.ArrayList;
import java.util.List;

public abstract class Interpreter {
    private byte[] fShiftRegisterValue;
    protected List fInterpreterListeners = null;
    protected LogoDrawing fLogoDrawing;
    protected WiringDiagram fWiringDiagram;
    protected int fCommand;
    protected VariableMemory fVM;
    protected StateMachine fStateMachine;

    public void addInterpreterListener(InterpreterListener listener) {
        if (!this.getInterpreterListeners().contains(listener)) {
            this.getInterpreterListeners().add(listener);
        }
    }

    public void removeInterpreterListener(InterpreterListener listener) {
        this.fInterpreterListeners.remove(listener);
    }

    protected void fireCycleFinishedEvent(boolean somethingChanged) {
        for (InterpreterListener interpreterListener : new ArrayList(this.getInterpreterListeners())) {
            interpreterListener.interpreterCycleFinished(somethingChanged);
        }
    }

    public List getInterpreterListeners() {
        if (this.fInterpreterListeners == null) {
            this.fInterpreterListeners = new ArrayList();
        }
        return this.fInterpreterListeners;
    }

    public void prepareInterpreter() {
        if (this.fWiringDiagram.getHardware().supports("supportNetwork")) {
            if (this.fVM != null) {
                this.fVM.init(0);
            } else {
                this.fVM = new VariableMemory(this.fWiringDiagram.getHardware().getIntProperty("VMSizeInByte"));
            }
        }
    }

    public abstract void start();

    public abstract long getCurrentSimulationClockTime();

    public abstract long getCurrentSimulationTimerTime();

    public StateMachine getStateMachine() {
        return this.fStateMachine;
    }

    public byte[] getShiftRegisterValue() {
        if (this.fShiftRegisterValue == null) {
            this.fShiftRegisterValue = this.fWiringDiagram == null ? new byte[1] : new byte[this.fWiringDiagram.getHardware().getMaxResource(18)];
        }
        return this.fShiftRegisterValue;
    }

    public void setShiftRegisterValue(byte newValue, int index) {
        this.getShiftRegisterValue()[index] = newValue;
    }

    public int readVM(int length, int address) {
        if (length == 1) {
            return this.fVM.get(address);
        }
        if (length == 2) {
            return this.fVM.getWord(address);
        }
        if (length == 4) {
            return this.fVM.getDoubleWord(address);
        }
        throw new IllegalArgumentException();
    }

    public void writeVM(int length, int address, int value) {
        if (this.fVM == null) {
            return;
        }
        if (length == 1) {
            this.fVM.put(address, value);
        } else if (length == 2) {
            this.fVM.putWord(address, value);
        } else if (length == 4) {
            this.fVM.putDoubleWord(address, value);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public LogoDrawing getLogoDrawing() {
        return this.fLogoDrawing;
    }
}

